/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.capability.object;

import dev.toma.gunsrpg.GunsRPG;
import dev.toma.gunsrpg.api.common.ITransaction;
import dev.toma.gunsrpg.api.common.data.GunKillData;
import dev.toma.gunsrpg.api.common.data.IKillData;
import dev.toma.gunsrpg.api.common.data.IPlayerCapEntry;
import dev.toma.gunsrpg.api.common.data.IProgressData;
import dev.toma.gunsrpg.api.common.data.ISkillProvider;
import dev.toma.gunsrpg.api.common.data.ITransactionManager;
import dev.toma.gunsrpg.api.common.skill.ITransactionValidator;
import dev.toma.gunsrpg.common.init.ModItems;
import dev.toma.gunsrpg.common.item.guns.GunItem;
import dev.toma.gunsrpg.common.skills.core.PlayerLevelTransactionValidator;
import dev.toma.gunsrpg.common.skills.core.SkillType;
import dev.toma.gunsrpg.common.skills.core.TransactionValidatorRegistry;
import dev.toma.gunsrpg.common.skills.transaction.TransactionManager;
import dev.toma.gunsrpg.common.skills.transaction.TransactionTypes;
import dev.toma.gunsrpg.common.skills.transaction.WeaponPointTransaction;
import dev.toma.gunsrpg.resource.progression.FakeLevelingStrategy;
import dev.toma.gunsrpg.resource.progression.IProgressionStrategy;
import dev.toma.gunsrpg.util.ModUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.SlimeEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;

public class PlayerProgressionData
implements IProgressData,
IPlayerCapEntry {
    private final PlayerEntity player;
    private final ISkillProvider skillProvider;
    private final ITransactionManager transactionManager = new TransactionManager();
    private final Map<GunItem, GunKillData> weaponStats = new HashMap<GunItem, GunKillData>();
    private final IProgressionStrategy strategy;
    private IPlayerCapEntry.IClientSynchReq request = () -> {};
    private boolean known;
    private int level;
    private int skillPoints;
    private int kills;
    private int requiredKills;

    public PlayerProgressionData(PlayerEntity player, ISkillProvider skillProvider) {
        this.player = player;
        this.skillProvider = skillProvider;
        this.transactionManager.registerHandler(TransactionTypes.SKILLPOINT_TRANSACTION, this::hasEnoughSkillpoints, this::handleSkillpointTransaction);
        this.transactionManager.registerHandler(TransactionTypes.WEAPON_POINT_TRANSACTION, this::hasEnoughWeaponPoints, this::handleWeaponPointTransaction);
        Object factory = TransactionValidatorRegistry.getValidatorFactory(PlayerLevelTransactionValidator.ID);
        Object validator = TransactionValidatorRegistry.getTransactionValidator(factory, null);
        this.strategy = ModUtils.firstNonnull(GunsRPG.getModLifecycle().getProgressionStrategyManager().getStrategy((ITransactionValidator)validator), FakeLevelingStrategy.INSTANCE);
        this.requiredKills = this.strategy.getRequiredKillCount(this.level);
    }

    @Override
    public IKillData getWeaponStats(GunItem item) {
        return this.weaponStats.computeIfAbsent(item, k -> new GunKillData(this.player, item));
    }

    @Override
    public boolean hasFunds(ITransaction<?> transaction) {
        return this.transactionManager.hasFunds(transaction);
    }

    @Override
    public void processTransaction(ITransaction<?> transaction) {
        this.transactionManager.handleTransaction(transaction);
    }

    @Override
    public void onLogIn() {
        if (!this.known) {
            this.known = true;
            if (!this.player.func_184812_l_()) {
                ModUtils.addItem(this.player, new ItemStack((IItemProvider)ModItems.STARTER_GEAR));
            }
            this.request.makeSyncRequest();
        }
    }

    @Override
    public void addLevels(int levels) {
        this.level = Math.min(this.getLevelLimit(), this.level + levels);
    }

    @Override
    public int getLevel() {
        return this.level;
    }

    @Override
    public int getLevelLimit() {
        return 100;
    }

    @Override
    public void advanceLevel(boolean notify) {
        this.level = Math.min(this.level + 1, this.getLevelLimit());
        this.kills = 0;
        this.strategy.applyRewards(this.player, this, this.level);
        this.updateRequiredKills();
        if (notify) {
            this.player.func_145747_a((ITextComponent)new StringTextComponent(TextFormatting.YELLOW + "=====[ " + new TranslationTextComponent("text.player.level_up").getString() + " ]====="), Util.field_240973_b_);
            this.player.func_145747_a((ITextComponent)new TranslationTextComponent("text.player.current_level", new Object[]{this.level}).func_240699_a_(TextFormatting.YELLOW), Util.field_240973_b_);
            this.skillProvider.onLevelUp(this.level, this.player);
            this.request.makeSyncRequest();
        }
    }

    @Override
    public int getPoints() {
        return this.skillPoints;
    }

    @Override
    public void awardPoints(int points) {
        this.skillPoints += points;
    }

    @Override
    public void onEnemyKilled(Entity enemy, ItemStack weapon) {
        if (!(enemy instanceof IMob) || enemy instanceof SlimeEntity) {
            return;
        }
        ++this.kills;
        if (this.level < this.getLevelLimit() && this.requiredKills <= this.kills) {
            this.advanceLevel(true);
        }
        if (weapon.func_77973_b() instanceof GunItem) {
            GunItem gun = (GunItem)weapon.func_77973_b();
            this.getWeaponStats(gun).onEnemyKilled(enemy, weapon);
        }
        this.request.makeSyncRequest();
    }

    @Override
    public void doUnlock() {
        this.level = this.getLevelLimit();
        this.skillPoints = Integer.MAX_VALUE;
        ForgeRegistries.ITEMS.getValues().stream().filter(item -> item instanceof GunItem).map(item -> (GunItem)item).forEach(gun -> {
            GunKillData killData = this.weaponStats.computeIfAbsent((GunItem)gun, k -> new GunKillData(this.player, (GunItem)gun));
            killData.doUnlock();
        });
    }

    @Override
    public void doLock() {
        this.level = 0;
        this.skillPoints = 0;
        this.kills = 0;
        this.weaponStats.clear();
        this.updateRequiredKills();
    }

    @Override
    public int getKills() {
        return this.kills;
    }

    @Override
    public int getRequiredKillCount() {
        return this.requiredKills;
    }

    @Override
    public int getFlag() {
        return 32;
    }

    @Override
    public void toNbt(CompoundNBT nbt) {
        CompoundNBT cnbt = new CompoundNBT();
        cnbt.func_74757_a("known", this.known);
        cnbt.func_74768_a("killCount", this.kills);
        cnbt.func_74768_a("requiredKillCount", this.requiredKills);
        cnbt.func_74768_a("level", this.level);
        cnbt.func_74768_a("points", this.skillPoints);
        CompoundNBT killData = new CompoundNBT();
        for (Map.Entry<GunItem, GunKillData> entry : this.weaponStats.entrySet()) {
            String id = entry.getKey().getRegistryName().toString();
            killData.func_218657_a(id, (INBT)entry.getValue().serializeNBT());
        }
        cnbt.func_218657_a("killData", (INBT)killData);
        nbt.func_218657_a("genericData", (INBT)cnbt);
    }

    @Override
    public void fromNbt(CompoundNBT nbt) {
        this.weaponStats.clear();
        CompoundNBT cnbt = nbt.func_150297_b("genericData", 10) ? nbt.func_74775_l("genericData") : new CompoundNBT();
        this.known = cnbt.func_74767_n("known");
        this.kills = cnbt.func_74762_e("killCount");
        this.requiredKills = cnbt.func_74762_e("requiredKillCount");
        this.level = cnbt.func_74762_e("level");
        this.skillPoints = cnbt.func_74762_e("points");
        CompoundNBT killData = cnbt.func_150297_b("killData", 10) ? cnbt.func_74775_l("killData") : new CompoundNBT();
        for (String key : killData.func_150296_c()) {
            Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(key));
            if (!(item instanceof GunItem)) continue;
            GunItem gun = (GunItem)item;
            GunKillData data = new GunKillData(this.player, gun);
            CompoundNBT dataNbt = killData.func_74775_l(key);
            data.deserializeNBT(dataNbt);
            this.weaponStats.put(gun, data);
        }
    }

    @Override
    public void setClientSynch(IPlayerCapEntry.IClientSynchReq request) {
        this.request = request;
    }

    private void updateRequiredKills() {
        this.requiredKills = this.strategy.getRequiredKillCount(this.level);
    }

    private boolean hasEnoughSkillpoints(ITransaction<SkillType<?>> transaction) {
        return transaction.total() <= this.skillPoints;
    }

    private void handleSkillpointTransaction(ITransaction<SkillType<?>> transaction) {
        this.skillPoints -= transaction.total();
        this.skillProvider.unlock(transaction.getData());
    }

    private boolean hasEnoughWeaponPoints(ITransaction<WeaponPointTransaction.IWeaponData> transaction) {
        GunItem item = transaction.getData().item();
        IKillData data = this.getWeaponStats(item);
        return transaction.total() <= data.getPoints();
    }

    private void handleWeaponPointTransaction(ITransaction<WeaponPointTransaction.IWeaponData> transaction) {
        GunItem item = transaction.getData().item();
        IKillData data = this.getWeaponStats(item);
        data.awardPoints(-transaction.total());
        this.skillProvider.unlock(transaction.getData().skill());
    }
}

